unit Parametros;

interface

uses
   Forms, SO_Unit, Controls, Classes, StdCtrls, ComCtrls;

type
  TFParametros = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    BOK: TButton;
    Button2: TButton;
    TLeitura: TUpDown;
    TDisco: TUpDown;
    TImpressao: TUpDown;
    TSlice: TUpDown;
    TSliceMin: TUpDown;
    TamDisco: TEdit;
    CheckShowMessages: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BOKClick(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FParametros: TFParametros;
  ConfirmaModificacoes:boolean;

implementation

{$R *.DFM}

procedure TFParametros.FormShow(Sender: TObject);
begin
   TSlice.Position:=default_TS;  //  Define o Time Slice padro
   TSliceMin.Position:= min_TS;

   TLeitura.Position:= TempoLeitura;  //  Tempo gasto para transferir uma pagina do dispositivo de entrada para o buffer
   TDisco.Position:=TempoDisco;  //  Tempo gasto para efetuar um acesso ao disco
   TImpressao.Position:=TempoImpressora; // Tempo gasto para transferir uma pgina do buffer para o dispositivo de sada

   CheckShowMessages.Checked:=ShowMessages;
end;


procedure TFParametros.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   if ConfirmaModificacoes then begin
       default_TS:=TSlice.Position;
       min_TS:=TSliceMin.Position;

       TempoLeitura:=TLeitura.Position;
       TempoDisco:=TDisco.Position;
       TempoImpressora:=TImpressao.Position;
       ShowMessages:=CheckShowMessages.Checked;
   end;
end;

procedure TFParametros.BOKClick(Sender: TObject);
begin
   ConfirmaModificacoes:= (Sender as TButton).Caption = 'OK';
   Close;
end;

procedure TFParametros.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
   if not (Key in ['0'..'9', #8]) then Key:=#0;
end;

end.
